﻿<?xml version="1.0" encoding="utf-8" ?> 
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>
	<xsl:output method='html'/>

	<xsl:template name="spreadsheet_start">
		<xsl:param name="name"/>
		<xsl:param name="nohandler"/>
		<xsl:param name="highlight"/>
		<xsl:param name="fit_height"/>
		<xsl:param name="autofit_minheight"/>
		<xsl:attribute name="m_fitHeight">
			<xsl:value-of select="$fit_height"/>
		</xsl:attribute>
		<xsl:attribute name="m_minHeight">
			<xsl:value-of select="$autofit_minheight"/>
		</xsl:attribute>
		<table class="spreadsheet_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="m_highlight">
				<xsl:value-of select="$highlight"/>
			</xsl:attribute>
			<xsl:attribute name="m_sheetName">
				<xsl:value-of select="$name"/>
			</xsl:attribute>
			<tr class="spreadsheet_headrow">
				<xsl:if test='not($nohandler)'>
					<td class="spreadsheet_handler_corner">&#160;</td>
				</xsl:if>
				<td class="spreadsheet_headrow_headers_cell">
					<div class="spreadsheet_headrow_container">
						<table class="spreadsheet_headrow_table" cellspacing="0" cellpadding="0">
							<tr class="spreadsheet_headrow_row">
								<xsl:call-template name="spreadsheet_columns_def">
									<xsl:with-param name="hidden">no</xsl:with-param>
									<xsl:with-param name="sheet" select="$name"/>
								</xsl:call-template>
							</tr>
						</table>
					</div>
				</td>
				<td class="spreadsheet_handler_corner">&#160;</td>
			</tr>
			<tr>
				<xsl:if test='not($nohandler)'>
					<td class="spreadsheet_handlers">
						<div class="spreadsheet_handler_container">
							<table class="spreadsheet_handler_table" cellspacing="0" cellpadding="0">
								<xsl:call-template name="spreadsheet_rows_def">
									<xsl:with-param name="hidden">yes</xsl:with-param>
									<xsl:with-param name="sheet" select="$name"/>
								</xsl:call-template>
							</table>
						</div>
					</td>
				</xsl:if>
				<td class="spreadsheet_data" colspan="2" rowspan="2">
					<div>
						<xsl:if test="$fit_height">
							<xsl:attribute name="class">spreadsheet_data_container_fit_height</xsl:attribute>
						</xsl:if>
						<xsl:if test="not($fit_height)">
							<xsl:attribute name="class">spreadsheet_data_container</xsl:attribute>
						</xsl:if>
						<table class="spreadsheet_data_table" cellspacing="0" cellpadding="0">
							<tr class="spreadsheet_headrow_row_hidden">
								<xsl:call-template name="spreadsheet_columns_def">
									<xsl:with-param name="hidden">yes</xsl:with-param>
									<xsl:with-param name="sheet" select="$name"/>
								</xsl:call-template>
								<td class="spreadsheet_handler_cell_hidden">
									<font color="buttonface">&#160;</font>
								</td>
							</tr>
							<xsl:call-template name="spreadsheet_rows_def">
								<xsl:with-param name="hidden">no</xsl:with-param>
								<xsl:with-param name="sheet" select="$name"/>
							</xsl:call-template>
						</table>
					</div>
				</td>
			</tr>
			<xsl:if test='not($nohandler)'>
				<tr class="spreadsheet_bottomrow">
					<td class="spreadsheet_handler_corner">&#160;</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	
	<xsl:template name="spreadsheet_column">
		<xsl:param name="name"/>
		<xsl:param name="width"/>
		<xsl:param name="hidden"/>
		<xsl:param name="type"/>
		<xsl:param name="minwidth"/>
		<xsl:param name="fixedSize"/>
		<xsl:param name="fixedPos"/>
		<xsl:param name="sortable"/>
		<xsl:if test='$hidden[.="yes"]'>
			<td class="spreadsheet_headrow_cell" width='{$width}'>
				<table class="spreadsheet_head_table" cellspacing="0" cellpading="0">
					<tr>
						<td nowrap="yes" class="spreadsheet_head_cell"><xsl:value-of select="$name"/></td>
					</tr>
				</table>
			</td>
		</xsl:if>
		<xsl:if test='$hidden[.="no"]'>
			<td class="spreadsheet_headrow_cell" width='{$width}' minwidth='{$minwidth}' m_fixedSize="{$fixedSize}" m_fixedPos="{$fixedPos}" m_sortable="{$sortable}">
				<table class="spreadsheet_head_table" cellspacing="0" cellpading="0">
					<tr>
						<td class="spreadsheet_head_cell" nowrap="yes" column_type="{$type}"><xsl:value-of select="$name"/></td>
						<xsl:if test='not($fixedSize)'>
							<td><span class="spreadsheet_resize_anchor"></span></td>
						</xsl:if>
					</tr>
				</table>
			</td>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="spreadsheet_row">
		<xsl:param name="hidden"/>
		<xsl:param name="sheet"/>
		<xsl:param name="hasChild"/>
		<xsl:param name="expanded"/>
		<xsl:if test='string($hidden)="yes"'>
			<tr class='spreadsheet_handler_row'>
				<td class="spreadsheet_handler_cell">
					&#160;
				</td>
			</tr>
		</xsl:if>
		<xsl:if test='string($hidden)="no"'>
			<tr nodeid='{@id}' class='spreadsheet_data_row'>
				<xsl:call-template name="spreadsheet_values_def">
					<xsl:with-param name="sheet" select="$sheet"/>
					<xsl:with-param name="hasChild" select="$hasChild"/>
					<xsl:with-param name="expanded" select="$expanded"/>
				</xsl:call-template>
				<td class="spreadsheet_handler_cell_hidden">
					<font color="buttonface">&#160;</font>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test='$hasChild and $expanded'>
			<xsl:call-template name="spreadsheet_rows_def">
				<xsl:with-param name="hidden" select="$hidden"/>
				<xsl:with-param name="sheet" select="$sheet"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="spreadsheet_value">
		<xsl:param name="value"/>
		<xsl:param name="type"/>
		<xsl:param name="handleIndent"/>
		<xsl:param name="parentList"/>
		<xsl:param name="hasChild"/>
		<xsl:param name="expanded"/>
		
		<xsl:variable name="me" select="self::*"/>
		
		<td nowrap="yes">
			<xsl:attribute name="value_type">
				<xsl:value-of select="$type"/>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test='$type and $type="number"'>
					<xsl:attribute name="class">spreadsheet_data_cell_number</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="class">spreadsheet_data_cell</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test='$handleIndent'>
				<xsl:if test='$parentList'>
					<xsl:for-each select="$parentList">
						<xsl:variable name="pos" select="position() + 1"/>
						<xsl:choose>
							<xsl:when test='position()=last()'>
								<xsl:choose>
									<xsl:when test='$me[following-sibling::*]'>
										<span class='spreadsheet_indent_end_L'>&#160;</span>
									</xsl:when>
									<xsl:otherwise>
										<span class='spreadsheet_indent_L'>&#160;</span>
									</xsl:otherwise>
								</xsl:choose>
								<span class='spreadsheet_indent_end_R'>&#160;</span>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test='following-sibling::*'>
										<span class='spreadsheet_indent_L'>&#160;</span>
										<span class='spreadsheet_indent_R'>&#160;</span>
									</xsl:when>
									<xsl:otherwise>
										<span class='spreadsheet_indent_space'>&#160;</span>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:if>
				<xsl:choose>
					<xsl:when test='$hasChild and $expanded'><span class='spreadsheet_treeNode_expand'>&#160;</span></xsl:when>
					<xsl:when test='$hasChild'><span class='spreadsheet_treeNode_collapse'>&#160;</span></xsl:when>
				</xsl:choose>
				<span class='spreadsheet_treeNode'></span>
			</xsl:if>
			<xsl:copy-of select='$value'/>
			<xsl:if test='not($value)'>
				<span>&#160;</span>
			</xsl:if>
		</td>
	</xsl:template>

</xsl:stylesheet>
